/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.bridge.request;

import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.OutgoingServiceRequest;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CReqInvokeNativeFunction
extends OutgoingServiceRequest {
    protected static final int C_TYPE_NULL = 78;
    protected static final int C_TYPE_BOOLEAN = 90;
    protected static final int C_TYPE_BYTE = 66;
    protected static final int C_TYPE_CHAR = 67;
    protected static final int C_TYPE_SHORT = 83;
    protected static final int C_TYPE_INT = 73;
    protected static final int C_TYPE_LONG = 74;
    protected static final int C_TYPE_FLOAT = 70;
    protected static final int C_TYPE_DOUBLE = 68;
    protected static final int C_TYPE_OBJECT = 79;
    protected static final int C_TYPE_VOID = 86;
    NativeBridge bridge;
    Object[] arguments;
    Object result;
    List namesRegisteredForThisCall = new ArrayList();

    public CReqInvokeNativeFunction(NativeBridge bridge, Object[] arguments) {
        this.bridge = bridge;
        this.arguments = arguments;
    }

    protected void writeRequest(DataOutputStream out) throws IOException {
        this.sendFunctionInformation(out);
        this.sendArgumentInformation(out);
    }

    private void sendArgumentInformation(DataOutputStream out) throws IOException {
        if (this.arguments == null) {
            out.writeShort(0);
            return;
        }
        out.writeShort(this.arguments.length);
        int argIndex = 0;
        while (argIndex < this.arguments.length) {
            Object arg = this.arguments[argIndex];
            if (arg == null) {
                out.writeByte(78);
            } else if (arg instanceof Integer) {
                out.writeByte(73);
                out.writeInt((Integer)arg);
            } else if (arg instanceof Short) {
                out.writeByte(83);
                out.writeShort(((Short)arg).shortValue());
            } else if (arg instanceof Long) {
                out.writeByte(74);
                out.writeLong((Long)arg);
            } else if (arg instanceof Float) {
                out.writeByte(70);
                out.writeFloat(((Float)arg).floatValue());
            } else if (arg instanceof Double) {
                out.writeByte(68);
                out.writeDouble((Double)arg);
            } else if (arg instanceof Byte) {
                out.writeByte(66);
                out.writeByte(((Byte)arg).byteValue());
            } else if (arg instanceof Character) {
                out.writeByte(67);
                out.writeChar(((Character)arg).charValue());
            } else if (arg instanceof Boolean) {
                out.writeByte(90);
                out.writeBoolean((Boolean)arg);
            } else {
                out.writeByte(79);
                String name = this.bridge.registerObject(arg);
                this.namesRegisteredForThisCall.add(name);
                out.writeUTF(name);
            }
            ++argIndex;
        }
    }

    private void deregisterNamesForThisCall() {
        Iterator iterator = this.namesRegisteredForThisCall.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            this.bridge.deregisterObject(name);
            iterator.remove();
        }
    }

    protected void processSuccessfulResponse() throws IOException {
        byte responseType = this.in.readByte();
        switch (responseType) {
            case 78: {
                this.result = null;
                break;
            }
            case 73: {
                this.result = new Integer(this.in.readInt());
                break;
            }
            case 83: {
                this.result = new Short(this.in.readShort());
                break;
            }
            case 74: {
                this.result = new Long(this.in.readLong());
                break;
            }
            case 70: {
                this.result = new Float(this.in.readFloat());
                break;
            }
            case 68: {
                this.result = new Double(this.in.readDouble());
                break;
            }
            case 66: {
                this.result = new Byte(this.in.readByte());
                break;
            }
            case 67: {
                this.result = new Character(this.in.readChar());
                break;
            }
            case 90: {
                this.result = new Boolean(this.in.readBoolean());
                break;
            }
            case 79: {
                String name = this.in.readUTF();
                this.result = this.bridge.lookupRegisteredObject(name);
                this.bridge.deregisterObject(name);
                break;
            }
            case 86: {
                this.result = null;
                break;
            }
            default: {
                throw new IOException("Unknown result type '" + (char)responseType + "' encountered.");
            }
        }
        this.deregisterNamesForThisCall();
    }

    protected void processFailedResponse(int errorCode, String errorMessage) {
        super.processFailedResponse(errorCode, errorMessage);
        this.deregisterNamesForThisCall();
    }

    public Object getFunctionResult() {
        return this.result;
    }

    protected abstract void sendFunctionInformation(DataOutputStream var1) throws IOException;
}

